<?php

namespace Ministra\Admin;

use Doctrine\DBAL\DriverManager;
use Ministra\Admin\Adapter\DataTableAdapter;
use Ministra\Admin\Container\SilexPsrContainer;
use Ministra\Admin\Lib\Middleware\Pipelines;
use Ministra\Admin\Repository\LicenseKeysRepository;
use Ministra\Admin\Repository\ServicesPackageRepository;
use Ministra\Admin\Repository\TariffPlanRepository;
use Ministra\Admin\Service\ServicesPackageGrid;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\cf970d68ff4f63a90163ab61ac38d307;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\r62dd1abb27bf63f53b1c8d03afcc7579\K95145a0487b5319fa7b198f6dcca3b9b;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\b9ab7afefc765dafedd3e86770b40cea as CoreLicenseKeysRepository;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\d415b80f2a7a58f1359ea89cdac8301f\ec5ab658974fd0474d9d725bf58a3494;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\d415b80f2a7a58f1359ea89cdac8301f\cdfbe97c38ed8e7d4ec00a67acde3d64;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\aea1fc3311ec4546a2e86ebaa6007e74;
use Pimple\Container;
use Pimple\ServiceProviderInterface;
use Psr\Container\ContainerInterface;
use Silex\Application;
class AppServiceProvider implements \Pimple\ServiceProviderInterface
{
    public function register(\Pimple\Container $container)
    {
        $container->offsetSet(\Psr\Container\ContainerInterface::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Container\SilexPsrContainer($app);
        });
        $container->offsetSet('pipelines', function (\Silex\Application $app) {
            return new \Ministra\Admin\Lib\Middleware\Pipelines();
        });
        $this->registerRepository($container);
        $container->offsetSet(\Ministra\Admin\Adapter\DataTableAdapter::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Adapter\DataTableAdapter($app['request_stack']->getCurrentRequest(), $app['db']);
        });
        $this->registerUtilConnection($container);
        $this->registerUtilService($container);
    }
    protected function registerRepository(\Pimple\Container $container)
    {
        $container->offsetSet(\Ministra\Admin\Repository\LicenseKeysRepository::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Repository\LicenseKeysRepository($app['db']);
        });
        $container->offsetSet(\Ministra\Admin\Repository\TariffPlanRepository::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Repository\TariffPlanRepository($app['db']);
        });
        $container->offsetSet(\Ministra\Admin\Repository\ServicesPackageRepository::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Repository\ServicesPackageRepository($app['db']);
        });
        $container->offsetSet(\Ministra\Admin\Service\ServicesPackageGrid::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Service\ServicesPackageGrid($app[\Ministra\Admin\Adapter\DataTableAdapter::class], $app[\Ministra\Admin\Repository\ServicesPackageRepository::class], $app[\Ministra\Admin\Repository\TariffPlanRepository::class]);
        });
    }
    protected function registerUtilConnection(\Pimple\Container $container)
    {
        $file = \realpath(__DIR__ . '/../../') . '/deploy/clear_key_util/db_util.sqlite';
        if (!\file_exists($file)) {
            \file_put_contents($file, '');
        }
        if (!\is_writable($file)) {
            throw new \RuntimeException("Clear key util database file does not writable: {$file}");
        }
        $dirs = [\dirname($file) . '/logs', \dirname($file) . '/reports'];
        foreach ($dirs as $dir) {
            if (!\is_writable($file)) {
                throw new \RuntimeException("Directory does not writable: {$dir}");
            }
        }
        if (!\extension_loaded('pdo_sqlite')) {
            throw new \Exception('SQLite extension missing');
        }
        $container->offsetSet('util.connection', \Doctrine\DBAL\DriverManager::getConnection(['driver' => 'pdo_sqlite', 'path' => $file]));
    }
    protected function registerUtilService(\Pimple\Container $container)
    {
        $container->offsetSet(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\d415b80f2a7a58f1359ea89cdac8301f\cdfbe97c38ed8e7d4ec00a67acde3d64::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\d415b80f2a7a58f1359ea89cdac8301f\cdfbe97c38ed8e7d4ec00a67acde3d64($app['util.connection']);
        });
        $container->offsetSet(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\d415b80f2a7a58f1359ea89cdac8301f\ec5ab658974fd0474d9d725bf58a3494::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\d415b80f2a7a58f1359ea89cdac8301f\ec5ab658974fd0474d9d725bf58a3494($app['util.connection']);
        });
        $container->offsetSet(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\r62dd1abb27bf63f53b1c8d03afcc7579\K95145a0487b5319fa7b198f6dcca3b9b::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\b9ab7afefc765dafedd3e86770b40cea($app['db']);
        });
        $container->offsetSet(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\cf970d68ff4f63a90163ab61ac38d307::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\cf970d68ff4f63a90163ab61ac38d307($app->offsetGet(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\d415b80f2a7a58f1359ea89cdac8301f\ec5ab658974fd0474d9d725bf58a3494::class), $app->offsetGet(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\d415b80f2a7a58f1359ea89cdac8301f\cdfbe97c38ed8e7d4ec00a67acde3d64::class), $app->offsetGet(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\r62dd1abb27bf63f53b1c8d03afcc7579\K95145a0487b5319fa7b198f6dcca3b9b::class), \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\S6cd8b4b5e46af8345d4ca9505e364c14\aea1fc3311ec4546a2e86ebaa6007e74::M6746ef7fa7bcaff9b0a60cc5db63747a, $app->offsetGet('util.path'));
        });
    }
}
