<?php

namespace Ministra\Admin;

use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\f1f42f11d53cbf1a52b00c3e1008054b3;
use Moust\Silex\Provider\CacheServiceProvider as MCacheServiceProvider;
use Pimple\Container;
class CacheServiceProvider extends \Moust\Silex\Provider\CacheServiceProvider
{
    public function register(\Pimple\Container $app)
    {
        $options = $app->offsetExists('memcache.options') ? $app['memcache.options'] : ['memcache.options' => ['host' => '127.0.0.1', 'default_timeout' => 1800]];
        if (null !== ($instance = $this->checkMemcacheConnect($options['memcache.options']['host']))) {
            $app['caches.options'] = ['memcache' => ['driver' => \get_class($instance) === 'Memcache' ? 'memcache' : 'memcached', 'memcache' => function () use($instance) {
                return $instance;
            }]];
        } else {
            $app['caches.options'] = ['filesystem' => ['driver' => 'file', 'cache_dir' => __DIR__ . '/../resources/cache/admin']];
        }
        return parent::register($app);
    }
    private function checkMemcacheConnect($hosts)
    {
        if (!\class_exists('Memcache') && !\class_exists('Memcached')) {
            return null;
        }
        $memcache = \class_exists('Memcached') ? new \Memcached() : new \Memcache();
        if (!\is_array($hosts)) {
            $hosts = [$hosts];
        }
        $countDisabled = 0;
        foreach ($hosts as $host) {
            if ($memcache->addServer($host, 11211) && $memcache->getStats() && $memcache->set('test', '123')) {
                $memcache->delete('test');
            } else {
                ++$countDisabled;
                \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\f1f42f11d53cbf1a52b00c3e1008054b3::E4651a75e1d26d4497bcc14b5ba73cb1f('Could not connect to memcached. Host: ' . $host);
            }
        }
        return $countDisabled === \count($hosts) ? null : $memcache;
    }
}
