<?php

namespace Ministra\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;
use PDO;
class Version20221024152055 extends \Doctrine\DBAL\Migrations\AbstractMigration
{
    const COUNTRIES_TABLE_NAME = 'countries';
    const COUNTRY_PHILIPPINES_ID = 608;
    const COUNTRY_PHILIPPINES_CODE_ISO2 = 'PH';
    const COUNTRY_PHILIPPINES_CODE_ISO3 = 'PHL';
    const COUNTRY_PHILIPPINES_NAME_EN = 'Philippines';
    const COUNTRY_PHILIPPINES_NAME_RU = 'Филиппины';
    const COUNTRIES_PARAMETERS = ['id' => ':id', 'iso2' => ':iso2', 'iso3' => ':iso3', 'name' => ':name', 'name_en' => ':name_en', 'region' => ':region', 'region_id' => ':region_id'];
    const COUNTRIES_VALUES = ['id' => self::COUNTRY_PHILIPPINES_ID, 'iso2' => self::COUNTRY_PHILIPPINES_CODE_ISO2, 'iso3' => self::COUNTRY_PHILIPPINES_CODE_ISO3, 'name' => self::COUNTRY_PHILIPPINES_NAME_RU, 'name_en' => self::COUNTRY_PHILIPPINES_NAME_EN, 'region' => 'Азия', 'region_id' => 4];
    const CITIES_TABLE_NAME = 'cities';
    const CITY_MANILA_ID = 1701668;
    const CITY_MANILA_NAME_EN = 'Manila';
    const CITY_MANILA_NAME_RU = 'Manila';
    const CITY_MANILA_TIMEZONE = 'Asia/Manila';
    const CITIES_PARAMETERS = ['id' => ':id', 'name' => ':name', 'name_en' => ':name_en', 'region' => ':region', 'country' => ':country', 'country_id' => ':country_id', 'timezone' => ':timezone'];
    const CITIES_VALUES = ['id' => self::CITY_MANILA_ID, 'name' => self::CITY_MANILA_NAME_RU, 'name_en' => self::CITY_MANILA_NAME_EN, 'region' => '', 'country' => self::COUNTRY_PHILIPPINES_NAME_EN, 'country_id' => self::COUNTRY_PHILIPPINES_ID, 'timezone' => self::CITY_MANILA_TIMEZONE];
    const OPEN_WEATHER_MAP_DATA_TABLE = 'all_cities';
    const OPEN_WEATHER_MAP_PARAMETERS = ['id' => ':id', 'name' => ':name', 'name_ru' => ':name_ru', 'country' => ':country', 'country_id' => ':country_id', 'admin1_code' => ':admin1_code', 'admin2_code' => ':admin2_code', 'admin3_code' => ':admin3_code', 'admin4_code' => ':admin4_code', 'lat' => ':lat', 'lon' => ':lon', 'timezone' => ':timezone'];
    const OPEN_WEATHER_MAP_VALUES = ['id' => self::CITY_MANILA_ID, 'name' => self::CITY_MANILA_NAME_EN, 'name_ru' => self::CITY_MANILA_NAME_RU, 'country' => self::COUNTRY_PHILIPPINES_CODE_ISO2, 'country_id' => self::COUNTRY_PHILIPPINES_ID, 'admin1_code' => '', 'admin2_code' => '05', 'admin3_code' => '05', 'admin4_code' => '', 'lat' => '14.6042', 'lon' => '120.9822', 'timezone' => self::CITY_MANILA_TIMEZONE];
    public function up(\Doctrine\DBAL\Schema\Schema $schema)
    {
        $this->connection->createQueryBuilder()->insert(self::COUNTRIES_TABLE_NAME)->values(self::COUNTRIES_PARAMETERS)->setParameters(self::COUNTRIES_VALUES)->execute();
        $this->connection->createQueryBuilder()->insert(self::CITIES_TABLE_NAME)->values(self::CITIES_PARAMETERS)->setParameters(self::CITIES_VALUES)->execute();
        $this->connection->createQueryBuilder()->insert(self::OPEN_WEATHER_MAP_DATA_TABLE)->values(self::OPEN_WEATHER_MAP_PARAMETERS)->setParameters(self::OPEN_WEATHER_MAP_VALUES)->execute();
    }
    public function down(\Doctrine\DBAL\Schema\Schema $schema)
    {
        $this->connection->createQueryBuilder()->delete(self::COUNTRIES_TABLE_NAME)->where('id = :id')->setParameters(['id' => self::COUNTRY_PHILIPPINES_ID], [\PDO::PARAM_INT])->execute();
        $this->connection->createQueryBuilder()->delete(self::CITIES_TABLE_NAME)->where('id = :id')->setParameters(['id' => self::CITY_MANILA_ID], [\PDO::PARAM_INT])->execute();
        $this->connection->createQueryBuilder()->delete(self::OPEN_WEATHER_MAP_DATA_TABLE)->where('id = :id')->setParameters(['id' => self::CITY_MANILA_ID], [\PDO::PARAM_INT])->execute();
    }
    public function getDescription()
    {
        return 'Add country \'Philippines\' and timezone \'Asia/Manila\'';
    }
}
