<?php

namespace Ministra\Admin\Service;

use Ministra\Admin\Adapter\DataTableAdapter;
use Ministra\Admin\Repository\ServicesPackageRepository;
use Ministra\Admin\Repository\TariffPlanRepository;
class ServicesPackageGrid
{
    private $dataTableAdapter;
    private $query;
    private $tariffPlanRepository;
    private $counterField = 'count(sp.id)';
    public function __construct(\Ministra\Admin\Adapter\DataTableAdapter $dataTableAdapter, \Ministra\Admin\Repository\ServicesPackageRepository $servicesPackageRepository, \Ministra\Admin\Repository\TariffPlanRepository $tariffPlanRepository)
    {
        $this->dataTableAdapter = $dataTableAdapter;
        $this->query = $servicesPackageRepository->getGridQuery();
        $this->tariffPlanRepository = $tariffPlanRepository;
        $this->init();
    }
    private function init()
    {
        $this->dataTableAdapter->process();
        $exprs = $this->query->expr()->orX();
        foreach ($this->dataTableAdapter->getLikeFiters() as $field => $value) {
            $param = $this->query->createNamedParameter('%' . $value . '%');
            $exprs->add($this->query->expr()->like($field, $param));
        }
        if ($exprs->count()) {
            $this->query->where($exprs);
        }
        foreach ($this->dataTableAdapter->getOrder() as $field => $order) {
            if ($field) {
                $this->query->addOrderBy($field, $order);
            }
        }
        $this->query->setMaxResults($this->dataTableAdapter->getLimit())->setFirstResult($this->dataTableAdapter->getOffset());
    }
    public function setFilters($filters)
    {
        foreach ($this->dataTableAdapter->getEqualFilters() as $filter => $value) {
            if (!\array_key_exists($filter, $filters)) {
                continue;
            }
            $this->addSubFilter($filters[$filter], $filter, $value);
        }
    }
    public function getData()
    {
        $list = $this->query->execute()->fetchAll();
        $usersCounters = $this->countFields(\array_column($list, 'id'));
        $data = [];
        foreach ($list as $item) {
            $data[] = ['id' => $item['id'], 'external_id' => $item['external_id'], 'name' => $item['name'], 'users_count' => \array_key_exists($item['id'], $usersCounters) ? $usersCounters[$item['id']] : 0, 'type' => $item['type'], 'all_services' => $item['all_services'], 'RowOrder' => 'dTRow_' . $item['id']];
        }
        return $data;
    }
    public function getTotalCount()
    {
        $query = clone $this->query;
        $totalQuery = $query->select($this->counterField)->resetQueryPart('where')->resetQueryPart('having')->resetQueryPart('orderBy')->setFirstResult(null)->setMaxResults(null);
        $total = $totalQuery->execute()->fetchColumn();
        return $total ?: 0;
    }
    public function getFilteredCount()
    {
        $query = clone $this->query;
        $filtered = $query->select($this->counterField)->resetQueryPart('orderBy')->setFirstResult(null)->setMaxResults(null)->execute()->fetchColumn();
        return $filtered ?: 0;
    }
    public function getDrawFlag()
    {
        return $this->dataTableAdapter->getDrawFlag();
    }
    private function addSubFilter($subFilter, $filter, $value)
    {
        foreach ($subFilter as $item) {
            if ($item['id'] == $value) {
                $value = \array_key_exists('value', $item) ? $item['value'] : $value;
                $param = $this->query->createNamedParameter($value);
                $this->query->andWhere($filter . ' = ' . $param);
                break;
            }
        }
    }
    private function countFields(array $ids)
    {
        $records = [];
        $userPerPackages = $this->tariffPlanRepository->countUsersPerPackages($ids);
        foreach ($userPerPackages as $counter) {
            $records[$counter['package_id']] += $counter['user_cont'];
        }
        $userPerSubscription = $this->tariffPlanRepository->countUsersPerSubscription($ids);
        foreach ($userPerSubscription as $counter) {
            $records[$counter['package_id']] += $counter['cnt'];
        }
        return $records;
    }
}
