<?php

namespace Ministra\Lib;

use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g58b21ad8584095b442bb4ed404e99dce;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7;
use Ministra\Lib\Course\CourseGetter;
use Ministra\Lib\Course\ProviderFactory;
class Course implements \Ministra\Lib\StbApi\Course
{
    private $db;
    private $codes;
    private $providerName;
    public function __construct()
    {
        $this->db = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance();
        $this->providerName = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g58b21ad8584095b442bb4ed404e99dce::get('course_provider');
        $providers = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g58b21ad8584095b442bb4ed404e99dce::get('course_providers_for_update');
        if (\array_key_exists($this->providerName, $providers)) {
            $this->codes = $providers[$this->providerName];
        }
    }
    public function getData()
    {
        $provider = \Ministra\Lib\Course\ProviderFactory::build($this->providerName, [$this->codes, $this->db]);
        if ($provider instanceof \Ministra\Lib\Course\CourseGetter) {
            return $provider->getData();
        }
        throw new \Exception(\sprintf('Class "%s" must implement CourseGetter interface', \get_class($provider)));
    }
}
