<?php

namespace Ministra\Lib;

use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g58b21ad8584095b442bb4ed404e99dce;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\B91ebc4a2170a66056f8eac1009f6bb85;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7;
class Event extends \Ministra\Lib\HTTPPush
{
    public static $allowed_events = ['send_msg', 'reboot', 'reload_portal', 'update_channels', 'play_channel', 'play_radio_channel', 'mount_all_storages', 'cut_off', 'update_image', 'update_epg', 'update_subscription', 'update_modules', 'cut_on', 'show_menu', 'additional_services_status', 'send_msg_with_video', 'send_msg_with_url'];
    private $param = ['user_list' => [], 'event' => '', 'header' => '', 'priority' => 0, 'msg' => '', 'need_confirm' => 0, 'reboot_after_ok' => 0, 'eventtime' => 0, 'auto_hide_timeout' => 0, 'param1' => '', 'post_function' => ''];
    private $pattern;
    private $db;
    private $ttl;
    public function __construct()
    {
        $this->db = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance();
        $this->pattern = $this->param;
    }
    public static function setSended($id)
    {
        $db = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance();
        $db->update('events', ['sended' => 1], ['id' => $id]);
    }
    public static function setConfirmed($id)
    {
        $db = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance();
        $db->update('events', ['confirmed' => 1, 'ended' => 1], ['id' => $id]);
    }
    public static function setEnded($id)
    {
        $db = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance();
        $db->update('events', ['ended' => 1], ['id' => $id]);
    }
    public static function getAllNotEndedEvents($uid)
    {
        if ($uid) {
            $db = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance();
            return $db->from('events')->where(['uid' => $uid, 'ended' => 0, 'eventtime>' => \date(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::bfdb5b69cb35540663f535207b3b1125)])->orderby('priority')->orderby('addtime')->get()->all();
        }
        return false;
    }
    public function setUserListByMac($list)
    {
        if (\is_string($list) || \is_int($list)) {
            if ($list == 'all') {
                $this->param['user_list'] = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\B91ebc4a2170a66056f8eac1009f6bb85::i567947f8b6eac795bf700e0fac905d37();
            } elseif ($list == 'online') {
                $this->param['user_list'] = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\B91ebc4a2170a66056f8eac1009f6bb85::o9cd6e61088e2d5d25d34881eb93ebb42();
            } else {
                $this->param['user_list'] = [\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\B91ebc4a2170a66056f8eac1009f6bb85::W278f7696f0090f223114de31e39db2f7($list)];
            }
        } else {
            $this->param['user_list'] = [];
            foreach ($list as $mac) {
                $this->param['user_list'][] = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\B91ebc4a2170a66056f8eac1009f6bb85::W278f7696f0090f223114de31e39db2f7($mac);
            }
        }
    }
    public function setUserListById($list)
    {
        if (\is_string($list) || \is_int($list)) {
            if ($list == 'all') {
                $this->param['user_list'] = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\B91ebc4a2170a66056f8eac1009f6bb85::i567947f8b6eac795bf700e0fac905d37();
            } else {
                $this->param['user_list'] = [$list];
            }
        } else {
            $this->param['user_list'] = $list;
        }
    }
    public function setAutoHideTimeout($timeout)
    {
        $this->param['auto_hide_timeout'] = $timeout;
    }
    public function setTtl($ttl)
    {
        $this->ttl = (int) $ttl;
    }
    protected function setEvent($event)
    {
        $this->param['event'] = $event;
    }
    protected function setMsg($msg)
    {
        $this->param['msg'] = $msg;
    }
    protected function setHeader($header = '')
    {
        $this->param['header'] = $header;
    }
    protected function setParam1($param1)
    {
        $this->param['param1'] = $param1;
    }
    protected function setPostFunction($post_function)
    {
        $this->param['post_function'] = $post_function;
    }
    protected function setNeedConfirm($need_confirm)
    {
        $this->param['need_confirm'] = $need_confirm;
    }
    protected function setRebootAfterOk($reboot_after_ok)
    {
        $this->param['reboot_after_ok'] = $reboot_after_ok;
    }
    protected function send()
    {
        if (!$this->param['eventtime']) {
            if (empty($this->ttl)) {
                if ($this->param['event'] == 'send_msg' || $this->param['event'] == 'send_msg_with_video') {
                    $this->ttl = 7 * 24 * 3600;
                } else {
                    $this->ttl = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g58b21ad8584095b442bb4ed404e99dce::get('watchdog_timeout') * 2;
                }
            }
            $this->setEventTime(\date('Y-m-d H:i:s', \time() + $this->ttl));
        }
        if (!$this->param['priority']) {
            if ($this->param['event'] == 'send_msg' || $this->param['event'] == 'send_msg_with_video') {
                $this->setPriority(2);
            } else {
                $this->setPriority(1);
            }
        }
        $this->saveInDb();
        $this->push();
        $this->resetEventOptions();
    }
    protected function setEventTime($eventtime)
    {
        $this->param['eventtime'] = $eventtime;
    }
    protected function setPriority($priority)
    {
        $this->param['priority'] = $priority;
    }
    protected function saveInDb()
    {
        if (\is_array($this->param['user_list']) && \count($this->param['user_list']) > 0) {
            $data = [];
            foreach ($this->param['user_list'] as $uid) {
                $data[] = ['uid' => $uid, 'event' => $this->param['event'], 'header' => $this->param['header'], 'addtime' => 'NOW()', 'eventtime' => $this->param['eventtime'], 'need_confirm' => $this->param['need_confirm'], 'reboot_after_ok' => $this->param['reboot_after_ok'], 'msg' => $this->param['msg'], 'priority' => $this->param['priority'], 'auto_hide_timeout' => $this->param['auto_hide_timeout'], 'param1' => $this->param['param1'], 'post_function' => $this->param['post_function']];
                if ($this->param['event'] == 'cut_off') {
                    \Ministra\Lib\c94d43331b986582d35f81652f91e1d1\b858fe3b3e1667e5e053cad0c4874638::s2ffe8cfc2083be1fb2f546d65a9cf846($uid);
                }
            }
            if ($this->param['event'] == 'send_msg' && $this->param['reboot_after_ok'] == 1) {
                \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->query('delete from events where uid in(' . \implode(',', $this->param['user_list']) . ') and event="send_msg" and sended=0 and reboot_after_ok=1');
            }
            $this->db->insert('events', $data);
        }
    }
    protected function resetEventOptions()
    {
        $this->param = $this->pattern;
    }
}
