<?php

namespace Ministra\Lib;

use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\e87b1fd04909f2937a56ec5b5d50aac0;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7;
class Google
{
    public $gapi_name;
    public $gapi_url;
    public $cache_expire = 3600;
    public $gapi_module;
    public $gapi_field;
    private $db;
    private $gapi_arr;
    private $cache_table;
    public function __construct()
    {
        $this->db = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance();
        $this->cache_table = 'gapi_cache_' . $this->gapi_name;
    }
    public function getData()
    {
        return $this->getDataFromDBCache();
    }
    private function getDataFromDBCache()
    {
        $content = $this->db->from($this->cache_table)->get()->first('content');
        $content = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\e87b1fd04909f2937a56ec5b5d50aac0::g42f505f47727c35750dfd0f6823c28f6(\base64_decode($content));
        if (\is_array($content)) {
            return $content;
        }
        return 0;
    }
    public function getDataFromGAPI()
    {
        $gapi_arr = [];
        $gapi_resp = \simplexml_load_file($this->gapi_url);
        if ($gapi_resp) {
            foreach ($gapi_resp->{$this->gapi_module}->{$this->gapi_field} as $item) {
                $new_item = [];
                foreach ($item as $field => $data) {
                    $new_item[$field] = (string) $data->attributes()->data;
                }
                $gapi_arr[] = $new_item;
            }
            $this->setDataDBCache($gapi_arr);
            return $gapi_arr;
        }
    }
    private function setDataDBCache($arr)
    {
        $content = \base64_encode(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\e87b1fd04909f2937a56ec5b5d50aac0::f76712cd11b45cc96b43a1b309252107($arr));
        $result = $this->db->from($this->cache_table)->get();
        $crc = $result->get('crc');
        if (\md5($content) != $crc) {
            $data = ['content' => $content, 'updated' => 'NOW()', 'url' => $this->gapi_url, 'crc' => \md5($content)];
            if ($result->count() == 1) {
                $this->db->update($this->cache_table, $data);
            } else {
                $this->db->insert($this->cache_table, $data);
            }
        } else {
            if ($result->count() == 1) {
                $this->db->update($this->cache_table, ['updated' => 'NOW()']);
            }
        }
    }
}
