<?php

namespace Ministra\Lib;

use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\e87b1fd04909f2937a56ec5b5d50aac0;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g974965637b063c004a1dfc7c145520ca;
class ItvSubscription
{
    private static $itv_subscription = false;
    public static function getBonusChannelsIds($uid)
    {
        if (self::$itv_subscription === false) {
            self::$itv_subscription = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->from('itv_subscription')->where(['uid' => $uid])->get()->first();
        }
        if (empty(self::$itv_subscription)) {
            return [];
        }
        $bonus_ch = self::$itv_subscription['bonus_ch'];
        if (empty($bonus_ch)) {
            return [];
        }
        $bonus_ch_arr = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\e87b1fd04909f2937a56ec5b5d50aac0::g42f505f47727c35750dfd0f6823c28f6(\Ministra\Lib\System::base64_decode($bonus_ch));
        if (!\is_array($bonus_ch_arr)) {
            return [];
        }
        return $bonus_ch_arr;
    }
    public static function getSubscriptionChannelsIds($uid)
    {
        $user = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->from('users')->where(['id' => (int) $uid])->get()->first();
        if (empty($user)) {
            return [];
        }
        if (\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g974965637b063c004a1dfc7c145520ca::getInstance()->c7f7d9472f8fcbb38ea68881a6e1bb89b()) {
            return \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->from('itv')->where(['base_ch' => 0])->get()->all('id');
        }
        if (self::$itv_subscription === false) {
            self::$itv_subscription = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->from('itv_subscription')->where(['uid' => $uid])->get()->first();
        }
        if (empty(self::$itv_subscription)) {
            return [];
        }
        $sub_ch = self::$itv_subscription['sub_ch'];
        if (empty($sub_ch)) {
            return [];
        }
        $sub_ch_arr = @\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\e87b1fd04909f2937a56ec5b5d50aac0::g42f505f47727c35750dfd0f6823c28f6(\Ministra\Lib\System::base64_decode($sub_ch));
        if (!\is_array($sub_ch_arr)) {
            return [];
        }
        return $sub_ch_arr;
    }
    public static function updateByUids($uids, $data)
    {
        if (empty($data)) {
            return false;
        }
        if (!\array_key_exists('bonus_ch', $data) || !\is_array($data['bonus_ch'])) {
            $data['bonus_ch'] = [];
        }
        if (!\array_key_exists('sub_ch', $data) || !\is_array($data['sub_ch'])) {
            $data['sub_ch'] = [];
        }
        if (\array_key_exists('sub_ch', $data)) {
            $data['sub_ch'] = \Ministra\Lib\System::base64_encode(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\e87b1fd04909f2937a56ec5b5d50aac0::f76712cd11b45cc96b43a1b309252107($data['sub_ch']));
        }
        if (\array_key_exists('bonus_ch', $data)) {
            $data['bonus_ch'] = \Ministra\Lib\System::base64_encode(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\e87b1fd04909f2937a56ec5b5d50aac0::f76712cd11b45cc96b43a1b309252107($data['bonus_ch']));
        }
        $data['addtime'] = 'NOW()';
        $result = false;
        foreach ($uids as $uid) {
            $subscription = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->from('itv_subscription')->where(['uid' => $uid])->get()->first();
            if (empty($subscription)) {
                $result = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->insert('itv_subscription', \array_merge($data, ['uid' => $uid]));
            } else {
                $result = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->update('itv_subscription', $data, ['uid' => $uid]);
            }
        }
        if (!$result) {
            return false;
        }
        return self::getByUids($uids);
    }
    public static function getByUids($uids = [])
    {
        $result = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->select('itv_subscription.*, users.mac as mac, users.ls as ls, ' . 'users.additional_services_on as additional_services_on')->from('itv_subscription')->join('users', 'itv_subscription.uid', 'users.id', 'LEFT');
        if (!empty($uids)) {
            $result = $result->in('uid', $uids);
        }
        $result = $result->get()->all();
        $result = \array_map(function ($item) {
            $item['sub_ch'] = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\e87b1fd04909f2937a56ec5b5d50aac0::g42f505f47727c35750dfd0f6823c28f6(\Ministra\Lib\System::base64_decode($item['sub_ch']));
            $item['bonus_ch'] = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\e87b1fd04909f2937a56ec5b5d50aac0::g42f505f47727c35750dfd0f6823c28f6(\Ministra\Lib\System::base64_decode($item['bonus_ch']));
            return $item;
        }, $result);
        return $result;
    }
}
