<?php

namespace Ministra\Lib;

use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7;
class NotificationFeed
{
    private $feed_url = 'https://not.ministra.com/feed';
    public function getCount($only_not_read = true)
    {
        $items = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->from('notification_feed')->where(['delay_finished_time<=' => \date(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::bfdb5b69cb35540663f535207b3b1125)])->count();
        if ($only_not_read) {
            $items->where(['`read`' => 0]);
        }
        return (int) $items->get()->counter();
    }
    public function getItems($only_not_read = true)
    {
        $items = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->from('notification_feed')->where(['delay_finished_time<=' => \date(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::bfdb5b69cb35540663f535207b3b1125)])->orderby('pub_date DESC, guid', 'DESC');
        if ($only_not_read) {
            $items->where(['`read`' => 0]);
        }
        $items = $items->get()->all();
        $items = \array_map(function ($item) {
            return new \Ministra\Lib\NotificationFeedItem($item);
        }, $items);
        return $items;
    }
    public function getNotDeletedItems()
    {
        $items = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->select('title, description, category, pub_date, `read`, link, guid')->from('notification_feed')->where(['deleted' => 0])->orderby('pub_date DESC, guid', 'DESC')->get()->all();
        return $items;
    }
    public function deleteByGuid($guid)
    {
        return \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->update('notification_feed', ['deleted' => 1], ['guid' => $guid])->result();
    }
    public function sync()
    {
        $language = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->from('administrators')->where(['login' => 'admin'])->get()->first('language');
        if (!$language) {
            $language = 'en';
        }
        $feed_url = $this->feed_url . (\strpos($this->feed_url, '?') ? '&' : '?') . 'lang=' . $language;
        $content = \file_get_contents($feed_url);
        if (!$content) {
            return false;
        }
        $feed = \simplexml_load_string($content);
        if (!$feed) {
            return false;
        }
        $result = true;
        foreach ($feed->channel->item as $item) {
            $item_arr = ['title' => (string) $item->title, 'description' => (string) $item->description, 'link' => (string) $item->link, 'category' => (string) $item->category, 'pub_date' => \date(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::bfdb5b69cb35540663f535207b3b1125, \strtotime((string) $item->pubDate)), 'guid' => (string) $item->guid];
            $notification = new \Ministra\Lib\NotificationFeedItem($item_arr);
            $result = $notification->sync() && $result;
        }
        return $result;
    }
    public function setRedByGuid($guid = null)
    {
        $where = $guid ? ['guid' => $guid] : [];
        return \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->update('notification_feed', ['`read`' => 1], $where)->result();
    }
    public function getItemByGUId($guid)
    {
        $item = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->from('notification_feed')->where(['guid' => $guid])->get()->first();
        if (!$item) {
            return false;
        }
        return new \Ministra\Lib\NotificationFeedItem($item);
    }
}
