<?php

namespace Ministra\Lib\RESTAPI\v1;

use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g974965637b063c004a1dfc7c145520ca;
class RESTCommandStbModules extends \Ministra\Lib\RESTAPI\v1\RESTCommand
{
    public function get(\Ministra\Lib\RESTAPI\v1\RESTRequest $request)
    {
        $stb_list = $request->getConvertedIdentifiers();
        if (empty($stb_list)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Empty stb list');
        }
        if (\count($stb_list) != 1) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Only one identifier allowed');
        }
        $uid = $stb_list[0];
        return ['disabled' => \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g974965637b063c004a1dfc7c145520ca::G6ea39c65d5cb303706046393fd5ec939($uid), 'restricted' => \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g974965637b063c004a1dfc7c145520ca::e99774bcb9c8027d420885524513d6f1($uid)];
    }
    public function update(\Ministra\Lib\RESTAPI\v1\RESTRequest $request)
    {
        $stb_list = $request->getConvertedIdentifiers();
        if (empty($stb_list)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Empty stb list');
        }
        $uids = $stb_list;
        $data = $request->getPut();
        if (empty($data)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('HTTP PUT data is empty');
        }
        if (!\array_key_exists('disabled', $data) && !\array_key_exists('restricted', $data)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Update data is empty');
        }
        if (\array_key_exists('disabled', $data)) {
            foreach ($uids as $uid) {
                \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g974965637b063c004a1dfc7c145520ca::Z1b9f12256ab71df43d1c03dc2a60dfcc($uid, $data['disabled']);
            }
        }
        if (\array_key_exists('restricted', $data)) {
            foreach ($uids as $uid) {
                \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g974965637b063c004a1dfc7c145520ca::w7ae35513c1998dbb864d2523c3f9cc5d($uid, $data['restricted']);
            }
        }
        return ['disabled' => \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g974965637b063c004a1dfc7c145520ca::G6ea39c65d5cb303706046393fd5ec939($uids[0]), 'restricted' => \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g974965637b063c004a1dfc7c145520ca::e99774bcb9c8027d420885524513d6f1($uids[0])];
    }
}
