<?php

namespace Ministra\Lib;

use ErrorException;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g58b21ad8584095b442bb4ed404e99dce;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\E61c406513b01ec38c17458153ceff8e9;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7;
class Storage
{
    private $storage;
    private $max_failures;
    private $stat_period;
    public function __construct($init_info = [])
    {
        if (empty($init_info)) {
            return;
        }
        if (!empty($init_info['id'])) {
            $this->storage = $this->getById($init_info['id']);
        } else {
            if (!empty($init_info['name'])) {
                $this->storage = $this->getByName($init_info['name']);
            }
        }
        if (empty($this->storage)) {
            throw new \ErrorException('Storage can not be initialized with values: ' . \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\E61c406513b01ec38c17458153ceff8e9::V0d67746c36b1147131b9264f69b05da8($init_info));
        }
        $this->max_failures = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g58b21ad8584095b442bb4ed404e99dce::getSafe('max_storage_failures', 3);
        $this->stat_period = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g58b21ad8584095b442bb4ed404e99dce::getSafe('storage_stat_period', 300);
    }
    public function getById($id)
    {
        return \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->from('storages')->where(['id' => $id])->get()->first();
    }
    public function getByName($name)
    {
        return \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->from('storages')->where(['storage_name' => $name])->get()->first();
    }
    public function markAsFailed($description = '')
    {
        $this->checkIfInitialized();
        \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->insert('storages_failure', ['storage_id' => $this->storage['id'], 'description' => $description])->insert_id();
        $failures = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->from('storages_failure')->count()->where(['storage_id' => $this->storage['id'], 'added>' => \date('Y-m-d H:i:s', \time() - $this->stat_period)])->get()->counter();
        if ($failures >= $this->max_failures) {
            $this->setOff();
        }
    }
    private function checkIfInitialized()
    {
        if (empty($this->storage)) {
            throw new \ErrorException('Storage not initialized');
        }
        return true;
    }
    public function setOff()
    {
        $this->checkIfInitialized();
        if ($this->storage['status'] == 0) {
            return true;
        }
        $result = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->update('storages', ['status' => 0], ['id' => $this->storage['id']]);
        if ($result) {
            \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->insert('master_log', ['log_txt' => 'Storage ' . $this->storage['storage_name'] . ' has been disabled after ' . $this->max_failures . ' failures in ' . $this->stat_period . 's', 'added' => 'NOW()']);
        }
        return $result;
    }
}
