<?php

namespace Ministra\Lib;

use Exception;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g58b21ad8584095b442bb4ed404e99dce;
class Weather implements \Ministra\Lib\StbApi\Weather
{
    protected $provider;
    public function __construct()
    {
        $this->provider = $this->getProvider();
    }
    private function getProvider()
    {
        $class = __NAMESPACE__ . '\\' . \ucfirst(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\g58b21ad8584095b442bb4ed404e99dce::getSafe('weather_provider', 'weatherco'));
        if (!\class_exists($class)) {
            throw new \Exception('Resource "' . $class . '" does not exist');
        }
        return new $class();
    }
    public function getCurrent()
    {
        return $this->provider->getCurrent();
    }
    public function getForecast()
    {
        return $this->provider->getForecast();
    }
    public function updateFullCurrent()
    {
        return $this->provider->updateFullCurrent();
    }
    public function updateFullForecast()
    {
        return $this->provider->updateFullForecast();
    }
    public function getCities($country, $search = '')
    {
        return $this->provider->getCities($country, $search);
    }
    public function getCityFieldName()
    {
        return $this->provider->getCityFieldName();
    }
}
