<?php

namespace Ministra\Lib;

use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\e87b1fd04909f2937a56ec5b5d50aac0;
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7;
class Widget
{
    public $db;
    public $widget_name;
    public $cache_table;
    public $cache_expire = 3600;
    public $rss_url;
    public $rss_fields = [];
    public $rss_atributes = [];
    public function __construct()
    {
        $this->db = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance();
        $this->cache_table = 'rss_cache_' . $this->widget_name;
    }
    public function getData()
    {
        return $this->getDataFromDBCache();
    }
    private function getDataFromDBCache()
    {
        $content = $this->db->get($this->cache_table)->first('content');
        $content = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\e87b1fd04909f2937a56ec5b5d50aac0::g42f505f47727c35750dfd0f6823c28f6(\base64_decode($content));
        if (\is_array($content)) {
            return $content;
        }
        return 0;
    }
    public function getDataFromRSS()
    {
        $rss_new = [];
        $rss = \simplexml_load_file($this->rss_url);
        if ($rss) {
            foreach ($rss->channel->item as $item) {
                $new_item = [];
                foreach ($this->rss_fields as $field) {
                    $new_item[$field] = (string) $item->{$field};
                }
                foreach ($this->rss_atributes as $atribute) {
                    $new_item['attributes_' . $atribute] = (string) $item->enclosure->attributes()->{$atribute};
                }
                $rss_new[] = $new_item;
            }
            $this->setDataDBCache($rss_new);
            return $rss_new;
        }
    }
    private function setDataDBCache($arr)
    {
        $content = \base64_encode(\Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\e19b518dccc8206e14e113c869a7ec85\e87b1fd04909f2937a56ec5b5d50aac0::f76712cd11b45cc96b43a1b309252107($arr));
        $result = $this->db->get($this->cache_table);
        if (\md5($content) != $result->first('crc')) {
            $data = ['content' => $content, 'updated' => 'NOW()', 'url' => $this->rss_url, 'crc' => \md5($content)];
            if ($result->count() == 1) {
                $this->db->update($this->cache_table, $data);
            } else {
                $this->db->insert($this->cache_table, $data);
            }
        }
    }
}
