from os.path import join, abspath, dirname
import re
from OpenSSL import crypto
from argparse import ArgumentParser

expire_days_count = 5


def create_self_signed_cert(expire_days: int):
    # create a key pair
    k = crypto.PKey()
    k.generate_key(crypto.TYPE_RSA, 4096)

    # create a self-signed cert
    cert = crypto.X509()
    cert.get_subject().C = "UA"
    cert.get_subject().ST = "Odessa"
    cert.get_subject().L = "Odessa"
    cert.get_subject().O = "Infomir"
    cert.get_subject().OU = "Infomir"
    cert.get_subject().CN = 'support.infomir.eu'
    cert.set_serial_number(1000)
    cert.gmtime_adj_notBefore(0)
    cert.gmtime_adj_notAfter(expire_days * 24 * 60 * 60)
    cert.set_issuer(cert.get_subject())
    cert.set_pubkey(k)
    cert.sign(k, 'sha1')

    content = crypto.dump_certificate(crypto.FILETYPE_PEM, cert)

    if isinstance(content, bytes):
        content = content.decode('utf-8')

    return content


if __name__ == '__main__':
    parser = ArgumentParser()
    parser.add_argument(
        '--remove',
        '-r',
        action='store_true',
        default=False,
        help='Remove certificate if set',
        dest='remove'
    )
    file = abspath(join(dirname(__file__), 'MTVCAClient', 'MTVLocalCertificateAuthority.php'))
    with open(file) as handler:
        content = handler.read()
        handler.close()

    args = parser.parse_args()

    if args.remove:
        content = re.sub(
            r'private \$mtvCertificate = \'(.+\n){1,}\';',
            'private $mtvCertificate = false;',
            content,
            re.M
        )
    else:
        cert = create_self_signed_cert(expire_days_count)
        content = re.sub(
            r'private \$mtvCertificate = false;',
            'private $mtvCertificate = \'{0}\';'.format(cert),
            content
        )
    with open(file, 'w') as handler:
        handler.write(content)
        handler.close()
