<?php

require __DIR__ . '/../common.php';
use Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7;
if (!isset($argv[1]) || $argv[1] == '--help') {
    echo "Usage: php ./cities_to_sql.php [CITIES TXT FILE]\n";
    echo "Text file with all cities you can find here http://www.geonames.org/export/\n";
    exit;
}
$dir = \dirname(__FILE__);
$inputFileName = \realpath($dir . '/' . $argv[1]);
if (!$inputFileName) {
    echo "File {$argv[1]} not found\n";
    exit;
}
$file = \file($inputFileName);
echo 'SET NAMES utf8; INSERT INTO all_cities ' . '(`id`, `name`, `name_ru`, `country`, `country_id`, `admin1_code`, `admin2_code`, `admin3_code`, `admin4_code`, ' . "`lat`, `lon`, `timezone`) VALUES \n";
$countries_map = [];
$countries = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->from('countries')->get()->all();
foreach ($countries as $country) {
    $countries_map[$country['iso2']] = $country;
}
$data = [];
$lineCount = 0;
foreach ($file as $line) {
    if ($lineCount >= 100) {
        echo \implode(",\n", $data);
        echo "; \n";
        $data = [];
        $lineCount = 0;
        echo "INSERT INTO all_cities (`id`, `name`, `name_ru`, `country`, `country_id`, `admin1_code`, `admin2_code`, `admin3_code`, `admin4_code`, `lat`, `lon`, `timezone`) VALUES \n";
    }
    $line = \str_replace('"', '\\"', $line);
    list($geonameid, $name, $asciiname, $alternatenames, $latitude, $longitude, $feature_class, $feature_code, $country_code, $admin1_code, $admin2_code, $admin3_code, $admin4_code, $population, $elevation, $dem, $cgiar, $timezone, $modification_date) = \explode("\t", $line);
    $name_ru = \Ministra\Lib\k43ef11a9578c2293bdfdd714ecc1b172\x6c4456d08c1312d52a4f35d8b06875b7::getInstance()->from('all_cities')->where(['id' => $geonameid])->get()->first('name_ru');
    $country_id = isset($countries_map[$country_code]) ? $countries_map[$country_code]['id'] : 0;
    if (!$country_id) {
        continue;
    }
    $data[] = '("' . $geonameid . '", "' . $name . '", "' . $name_ru . '", "' . $country_code . '", "' . $country_id . '", "' . $admin1_code . '", "' . $admin2_code . '", "' . $admin3_code . '", "' . $admin4_code . '", "' . $latitude . '", "' . $longitude . '", "' . $timezone . '")';
    $lineCount++;
}
echo \implode(",\n", $data);
echo "; \n";
