<?php

if (\PHP_SAPI != 'cli') {
    exit;
}
$metapackage = !empty($argv[1]) ? $argv[1] : \null;
require __DIR__ . '/../common.php';
use Ministra\Lib\SmartLauncherAppsManager;
use Ministra\Lib\SmartLauncherAppsManagerConflictException;
$apps_manager = new \Ministra\Lib\SmartLauncherAppsManager();
try {
    $apps_manager->resetApps($metapackage, !empty($metapackage));
} catch (\Ministra\Lib\SmartLauncherAppsManagerConflictException $e) {
    echo $e->getMessage() . "\n";
    $conflicts = $e->getConflicts();
    foreach ($conflicts as $conflict) {
        echo "\tApplication: " . $conflict['target'] . ":\n";
        echo "\t\tDependency: " . $conflict['alias'] . "\n";
        echo "\t\tExpression: " . $conflict['current_version'] . "\n";
    }
}
